package com.hero.objects.powers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class AnalyzeSense extends SenseAdder {

	private static String xmlID = "ANALYZESENSE";

	public AnalyzeSense(Element root) {
		super(root, AnalyzeSense.xmlID);
	}

	@Override
	public ArrayList<Adder> getAssignedAdders() {
		ArrayList<Adder> ret = assignedAdders;
		if (ret == null) {
			assignedAdders = new ArrayList<Adder>();
			ret = assignedAdders;
		}
		ArrayList<String> purchasedGroups = getSenseGroups();
		if (levelValue < 1) {
			return ret;
		}
		OUTER: for (int i = ret.size() - 1; i >= 0; i--) {
			Adder ad = ret.get(i);
			if (ad.getXMLID().equals("GROUP")
					&& (ad.getSelectedOption() != null)) {
				if (ad.getSelectedOption().getXMLID().equals(
						getSelectedOption().getXMLID())) {
					ret.remove(i);
					continue OUTER;
				}
				ArrayList<SenseGroup> groups = SenseGroup.getAllGroups();
				GROUPS: for (SenseGroup group : groups) {
					if (group.getXMLID().equals(
							ad.getSelectedOption().getXMLID())) {
						ArrayList<String> adders = group
								.getSenseAdders(getID());
						if (adders.contains(getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						if (!adders.contains("DISCRIMINATORY")) {
							ret.remove(i);
							continue OUTER;
						}
						if (levelValue < 1) {
							ad.setBaseCost(groupCost);
						} else {
							ad.setBaseCost(groupCost * levels);
						}
						break GROUPS;
					}
				}
			} else if (ad.getXMLID().endsWith("GROUP")) {
				if (ad.getXMLID().equals(getSelectedOption().getXMLID())) {
					ret.remove(i);
					continue OUTER;
				}
				ArrayList<SenseGroup> groups = SenseGroup.getAllGroups();
				GROUPS: for (SenseGroup group : groups) {
					if (group.getXMLID().equals(ad.getXMLID())) {
						ArrayList<String> adders = group
								.getSenseAdders(getID());
						if (adders.contains(getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						if (!adders.contains("DISCRIMINATORY")) {
							ret.remove(i);
							continue OUTER;
						}
						if (levelValue < 1) {
							ad.setBaseCost(groupCost);
						} else {
							ad.setBaseCost(groupCost * levels);
						}
						break GROUPS;
					}
				}
			} else if (ad.getXMLID().equals("SINGLE")
					&& (ad.getSelectedOption() != null)) {
				if (ad.getSelectedOption().getXMLID().equals(
						getSelectedOption().getXMLID())) {
					ret.remove(i);
					continue OUTER;
				}
				ArrayList<Sense> senses = Sense.getAllSenses();
				SENSES: for (Sense sense : senses) {
					if (sense.getXMLID().equals(
							ad.getSelectedOption().getXMLID())) {
						if (purchasedGroups.contains(sense.getGroup()
								.getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						ArrayList<String> adders = sense
								.getBuiltInSenseAdders(getID());
						if (adders.contains(getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						if (!adders.contains("DISCRIMINATORY")) {
							ret.remove(i);
							continue OUTER;
						}
						if (levelValue < 1) {
							ad.setBaseCost(senseCost);
						} else {
							ad.setBaseCost(senseCost * levels);
						}
						break SENSES;
					}
				}
			} else {
				if (ad.getXMLID().equals(getSelectedOption().getXMLID())) {
					ret.remove(i);
					continue OUTER;
				}
				ArrayList<Sense> senses = Sense.getAllSenses();
				SENSES: for (Sense sense : senses) {
					if (sense.getXMLID().equals(ad.getXMLID())) {
						if (purchasedGroups.contains(sense.getGroup()
								.getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						ArrayList<String> adders = sense
								.getBuiltInSenseAdders(getID());
						if (adders.contains(getXMLID())) {
							ret.remove(i);
							continue OUTER;
						}
						if (!adders.contains("DISCRIMINATORY")) {
							ret.remove(i);
							continue OUTER;
						}
						if (levelValue < 1) {
							ad.setBaseCost(senseCost);
						} else {
							ad.setBaseCost(senseCost * levels);
						}
						break SENSES;
					}
				}
			}
		}
		return ret;
	}

	@Override
	protected ArrayList<Adder> getAutomaticAdders() {
		ArrayList<Adder> ret = new ArrayList<Adder>();
		ArrayList<String> purchasedGroups = getSenseGroups();
		if ((getSelectedOption() == null)
				|| (getSelectedOption().getXMLID() == null)) {
			ArrayList<Adder> options = getOptions();
			if (options.size() > 0) {
				setSelectedOption(options.get(0));
			}
		}
		if ((getSelectedOption() == null)
				|| (getSelectedOption().getXMLID() == null)) {
			return ret;
		}
		if ((groupCost > 0) && !getSelectedOption().getXMLID().equals("ALL")) {
			ArrayList<String> groups = getSenseGroups();
			ArrayList<SenseGroup> allGroups = SenseGroup.getOwnedGroups();
			for (SenseGroup group : allGroups) {
				if (group.getXMLID().equals("UNUSUALGROUP")
						|| group.getXMLID().equals("NOGROUP")) {
					continue;
				} else if (groups.contains(group.getXMLID())) {
					continue;
				} else {
					ArrayList<String> adders = group.getSenseAdders(getID());
					if (adders.contains(getXMLID())) {
						continue;
					}
					if (!adders.contains("DISCRIMINATORY")) {
						continue;
					}
					Adder g = new Adder(group);
					g.setAvailableAdders(new ArrayList<Adder>());
					g.setExclusive(true);
					if (levelValue < 1) {
						g.setBaseCost(groupCost);
					} else {
						g.setLevelValue(-1);
						g.setBaseCost(groupCost * levels);
					}
					ret.add(g);
				}
			}
		}
		if (senseCost > 0) {
			ArrayList<String> senses = getSenses();
			ArrayList<Sense> allSenses = Sense.getOwnedSenses();
			for (Sense sense : allSenses) {
				if (senses.contains(sense.getXMLID())) {
					continue;
				} else if (purchasedGroups
						.contains(sense.getGroup().getXMLID())) {
					continue;
				} else {
					ArrayList<String> adders = sense
							.getBuiltInSenseAdders(getID());
					if (adders.contains(getXMLID())) {
						continue;
					}
					if (!adders.contains("DISCRIMINATORY")) {
						continue;
					}
					Adder g = new Adder(sense);
					g.setExclusive(true);
					g.setAvailableAdders(new ArrayList<Adder>());
					if (levelValue < 1) {
						g.setBaseCost(senseCost);
					} else {
						g.setBaseCost(senseCost * levels);
					}
					ret.add(g);
				}
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		return "";
	}

	@Override
	public ArrayList<Adder> getOptions() {
		ArrayList<Adder> ret = new ArrayList<Adder>();

		if (groupCost > 0) {
			ArrayList<SenseGroup> all = SenseGroup.getOwnedGroups();
			for (SenseGroup gr : all) {
				if ((GenericObject.findObjectByID(ret, gr.getXMLID()) == null)
						&& !gr.getSenseAdders(getID()).contains(getXMLID())
						&& gr.getSenseAdders().contains("DISCRIMINATORY")) {
					Adder ad = new Adder(gr);
					if (levelValue > 0) {
						ad.setLevelCost(groupCost);
					} else {
						ad.setBaseCost(groupCost);
					}
					ret.add(ad);
				}
			}
		}
		if (senseCost > 0) {
			ArrayList<Sense> all = Sense.getOwnedSenses();
			for (Sense gr : all) {
				if ((GenericObject.findObjectByID(ret, gr.getXMLID()) == null)
						&& !gr.getBuiltInSenseAdders(getID()).contains(
								getXMLID())
						&& gr.getBuiltInSenseAdders()
								.contains("DISCRIMINATORY")) {
					Adder ad = new Adder(gr);
					if (levelValue > 0) {
						ad.setLevelCost(senseCost);
					} else {
						ad.setBaseCost(senseCost);
					}
					ret.add(ad);
				}
			}
		}
		if ((allCost > 0) && (GenericObject.findObjectByID(ret, "ALL") == null)
				&& (ret.size() > 0)) {
			Adder allAdder = new Adder(new Element("ADDER"));
			allAdder.setXMLID("ALL");
			if (levelValue > 0) {
				allAdder.setLevelCost(allCost);
			} else {
				allAdder.setBaseCost(allCost);
			}
			allAdder.setDisplay("All Sense Groups");
			allAdder.setAlias("All Sense Groups");
			ret.add(0, allAdder);
		}
		return ret;
	}

	/**
	 * Sorts after Discriminatory...
	 */
	@Override
	public String getSortingValue() {
		return "DISCRIMINATORY" + super.getSortingValue();
	}
}